<?php
declare(strict_types=1);
// Minimal, vendor-free setter. Open in browser.
require_once __DIR__ . '/config.php';

$defaultUrl = 'https://dnet.pingbaz.site/bot/bot.php';
$url = isset($_GET['url']) ? (string)$_GET['url'] : $defaultUrl;

$api = 'https://api.telegram.org/bot' . BOT_TOKEN . '/setWebhook';
$ch = curl_init($api);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => ['url' => $url, 'drop_pending_updates' => 'true'],
    CURLOPT_TIMEOUT => 20,
]);
$resp = curl_exec($ch);
$err  = curl_error($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

header('Content-Type: application/json; charset=utf-8');
if ($resp === false) {
    echo json_encode(['ok' => false, 'error' => $err, 'http' => $http], JSON_UNESCAPED_UNICODE);
    exit;
}
echo $resp;
