<?php
declare(strict_types=1);

require_once __DIR__ . '/config.php';

init_schema(); // ensure tables exist

$raw = file_get_contents('php://input');
if (!$raw) {
    http_response_code(200);
    echo 'OK';
    exit;
}

// file_put_contents(__DIR__.'/last_update.json', $raw); // debug if needed

$update = json_decode($raw, true);
if (!$update) {
    http_response_code(200);
    echo 'NO_JSON';
    exit;
}

if (isset($update['message'])) {
    $msg = $update['message'];
    $chat_id = $msg['chat']['id'] ?? null;
    $username = $msg['from']['username'] ?? '';
    $first_name = $msg['from']['first_name'] ?? '';

    if ($chat_id !== null) {
        ensure_user($chat_id, $username, $first_name);
    }

    $text = trim($msg['text'] ?? '');
    if (strpos($text, '/start') === 0) {
        require __DIR__ . '/commands/start.php';
    } elseif ($text === '/verify') {
        require __DIR__ . '/commands/verify.php';
    } elseif ($text === '/trial') {
        require __DIR__ . '/commands/trial.php';
    } elseif ($text === '/admin' && $chat_id == ADMIN_ID) {
        $pdo = db();
        $user_count = (int)$pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
        $trial_count = (int)$pdo->query("SELECT COUNT(*) FROM trials")->fetchColumn();
        send_text($chat_id, "📊 آمار فعلی:\n👥 کاربران: $user_count\n🎫 تست‌ها: $trial_count");
    } else {
        require __DIR__ . '/commands/start.php';
    }
} elseif (isset($update['callback_query'])) {
    $cb = $update['callback_query'];
    $chat_id = $cb['message']['chat']['id'] ?? null;
    $username = $cb['from']['username'] ?? '';
    $first_name = $cb['from']['first_name'] ?? '';

    if ($chat_id !== null) {
        ensure_user($chat_id, $username, $first_name);
    }

    $data = $cb['data'] ?? '';
    if (!empty($cb['id'])) {
        answer_cb($cb['id']); // remove loading
    }

    if ($data === 'verify') {
        require __DIR__ . '/commands/verify.php';
    } elseif ($data === 'trial') {
        require __DIR__ . '/commands/trial.php';
    } else {
        require __DIR__ . '/commands/start.php';
    }
}

http_response_code(200);
echo 'OK';
